"""
HB_GuideSnap V1.1

Last Modified: Oct/11/2018
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_GuideSnap

Description-US: Enables Guide Snap and disables all other Snapping Modes. [SHIFT: Add Guide Snap, CTRL: Disable Guide Snap]

Video Tutorial:
https://youtu.be/eEcAttV56kE?t=27m25s


Name-DE: HB_GuideSnap
Description-DE: Aktiviert Hilfslinien Snapping und deaktiviert alle anderen Snapping Modi. [SHIFT: Hilfslinien Snap zusätzlich, CTRL: Hilfslinien Snap deaktivieren]


ChangeLog:

Jun/11/2015 V1.0
- Release Version

Oct/11/2018 V1.1
- New Highres Icon

"""

import c4d
from c4d.modules import snap


def main():
    
    if not (c4d.IsCommandChecked(440000121)):
        c4d.CallCommand(440000121) # Snapping on
    
    bc = c4d.BaseContainer()
    mysettings_bc=c4d.BaseContainer()
    if c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD,c4d.BFM_INPUT_CHANNEL,bc):
        
        if bc[c4d.BFM_INPUT_QUALIFIER] ==0 :
            
            c4d.CallCommand(c4d.SNAP_SETTINGS_AUTO)
            
            snap.EnableSnap(False, doc, c4d.SNAPMODE_POINT)
            snap.EnableSnap(False, doc, c4d.SNAPMODE_EDGE)
            snap.EnableSnap(False, doc, c4d.SNAPMODE_POLYGON)
            snap.EnableSnap(False, doc, c4d.SNAPMODE_SPLINE)
            snap.EnableSnap(False, doc, c4d.SNAPMODE_AXIS)
            snap.EnableSnap(False, doc, c4d.SNAPMODE_INTERSECTION)
            snap.EnableSnap(False, doc, c4d.SNAPMODE_MIDPOINT)
            snap.EnableSnap(False, doc, c4d.SNAPMODE_WORKPLANE)
            snap.EnableSnap(True, doc, c4d.SNAPMODE_GUIDE)
        
        if bc[c4d.BFM_INPUT_QUALIFIER] ==1 :
            snap.EnableSnap(True, doc, c4d.SNAPMODE_GUIDE)
            
        if bc[c4d.BFM_INPUT_QUALIFIER] ==2 :
            snap.EnableSnap(False, doc, c4d.SNAPMODE_GUIDE)
    
    
    c4d.EventAdd()

if __name__=='__main__':
    main()
